/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.entity.pelican;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import satisfyu.beachparty.entity.pelican.PelicanEntity;

public class PelicanModel<T extends PelicanEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation PELICAN_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("beachparty", "pelican"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart wing0;
    private final ModelPart wing1;

    public PelicanModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leg0 = root.m_171324_("leg0");
        this.leg1 = root.m_171324_("leg1");
        this.wing0 = root.m_171324_("wing0");
        this.wing1 = root.m_171324_("wing1");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(17, 1).m_171488_(-3.0f, -4.0f, -4.0f, 6.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(18, 18).m_171488_(0.0f, -2.0f, 4.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -9.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(1, 30).m_171488_(-2.0f, -5.0f, -10.0f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(1, 22).m_171488_(-2.0f, -6.0f, -10.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        PartDefinition leg0 = modelPartData.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(6, 45).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)1.0f));
        PartDefinition leg1 = modelPartData.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(6, 45).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)19.0f, (float)1.0f));
        PartDefinition wing0 = modelPartData.m_171599_("wing0", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(-1.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        PartDefinition wing1 = modelPartData.m_171599_("wing1", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(0.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.head.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.leg0.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.leg1.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.wing0.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.wing1.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leg0, (Object)this.leg1, (Object)this.wing0, (Object)this.wing1);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.leg0.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
    }
}

